# Archivos de datos abiertos de Participación Ciudadana GT


Este archivo ZIP contiene archivos para estudiar e investigar sobre esta plataforma de participación.


## Núcleo

### users

* id: El identificador único de la usuaria
* name: El nombre que se muestra de la usuaria
* nickname: El nombre de usuaria de la usuaria
* about: El texto "Acerca de" incluido en el perfil de usuaria
* avatar_url: El avatar de la usuaria
* profile_url: La URL del perfil de la usuaria
* direct_messages_enabled: Si la usuaria permite mensajes directos o no
* deleted: Si la usuaria fue eliminada o no
* badge: La insignia de la usuaria
* groups: El ID y el nombre del grupo de usuarias


### taxonomies

* id: El identificador único de esta taxonomía
* name: El nombre de esta taxonomía
* parent_id: Los identificadores únicos de la taxonomía "madre" (si existe)
* weight: El orden en el que se muestra esta taxonomía
* children_count: El recuento de "hijas" (sub-taxonomías) que tiene esta taxonomía
* taxonomizations_count: El recuento de los recursos (debates, proyectos, propuestas, encuentros, resultados, etc.) que utilizan esta taxonomía
* created_at: La fecha en la que se creó esta taxonomía
* updated_at: La fecha en que esta taxonomía fue actualizada por última vez
* filters_count: La cantidad de filtros que utilizan esta taxonomía
* filter_items_count: La cantidad de filtros de elementos que utilizan esta taxonomía
* part_of: Utilizado para detectar si esta taxonomía es "hija" (sub-categoría) de otra taxonomía
* is_root: Cierto ("true"): si esta taxonomía no tiene ninguna "madre" (no cuelga de otra taxonomía)



## Espacios

### participatory_processes

* id: El identificador único del proceso
* title: El título del proceso
* slug: El nombre corto del proceso (usado para fines de identificación, para la URL)
* reference: La referencia única del proceso participativo
* created_at: La fecha en la que se creó este proceso participativo
* updated_at: La fecha de la última actualización de este proceso participativo
* published_at: La fecha en la que se publicó este proceso participativo
* follows_count: El número de usuarias que siguen este proceso participativo
* hashtag: La etiqueta que utiliza el proceso en Twitter/X
* short_description: Una breve descripción del proceso
* description: Una descripción larga del proceso
* promoted: Si el proceso está destacado o no
* url: La URL del proceso participativo
* subtitle: El subtítulo del proceso
* remote_hero_image_url: La URL de la imagen principal del proceso
* announcement: La información del anuncio/aviso (llamada)
* start_date: La fecha de inicio del proceso
* end_date: La fecha de finalización del proceso
* developer_group: El grupo promotor del proceso. Quien está promoviendo el proceso.
* local_area: El área de organización del proceso. Esto es el área de organización de la que depende este proceso.
* meta_scope: Los metadatos del ámbito territorial del proceso
* participatory_scope: El ámbito territorial de la participación del proceso
* participatory_structure: La estructura participativa del proceso. Esto es como se decide en el proceso.
* target: Las destinatarias del proceso. Quien está llamado a participar en el proceso.
* area: El área a la que pertenece el proceso
* participatory_process_group: El grupo del proceso, si forma parte de alguno
* scope: El ámbito territorial del proceso
* scopes_enabled: Si el ámbito territorial está habilitado o no
* participatory_process_type: El tipo del proceso



## Componentes

### meetings

* id: El identificador único del encuentro
* author: Los datos de autoría de este encuentro
* participatory_space: A qué espacio pertenece este encuentro (proceso participativo, asamblea, etc.)
* taxonomies: Las taxonomías a las que pertenece este encuentro
* component: El componente al que pertenece este encuentro
* title: El título del encuentro
* description: La descripción del encuentro
* start_time: La fecha y hora en que se inició este encuentro
* end_time: La fecha y hora en que terminó este encuentro
* attendees: El número de personas que asistieron a este encuentro
* contributions: El número de contribuciones realizadas en este encuentro por las asistentes
* organizations: Las organizaciones que asistieron a esta reunión
* address: La dirección del encuentro en caso de que este sea presencial y tenga una ubicación física
* location: La localización del encuentro
* reference: El identificador único del recurso en esta plataforma
* attachments: El número de archivos adjuntos en este encuentro
* url: La URL del encuentro
* related_proposals: Las propuestas relacionadas con este encuentro
* related_results: Los resultados relacionados con este encuentro
* published: Cuando se publicó el encuentro
* withdrawn: Si se canceló el encuentro
* withdrawn_at: Cuando fue retirado/cancelado este encuentro
* location_hints: Detalle de ubicación dentro del lugar donde se celebró el encuentro
* created_at: La fecha en la que se creó este encuentro
* updated_at: La fecha de la última actualización del encuentro
* latitude: La latitud del lugar de encuentro
* longitude: La longitud del lugar de encuentro
* follows_count: El número de seguidoras que tiene el encuentro
* private_meeting: Si el encuentro fue privado o no
* transparent: La visibilidad del encuentro para visitantes
* registration_form_enabled: Si se habilitó, o no, un formulario de inscripción al encuentro
* comments: Los datos de los comentarios del encuentro
* online_meeting_url: La URL de la sala de videoconferencias
* closing_visible: La visibilidad de la información de cierre del encuentro
* closing_report: Acta/Informe del encuentro cerrado
* attending_organizations: Las organizaciones que asistieron a este encuentro
* registration_url: La URL para inscribirse al encuentro
* decidim_user_group_id: ID del grupo de usuarias involucrado en el encuentro
* decidim_author_type: Tipo de autoría (origen) del encuentro
* video_url: La URL del vídeo del encuentro
* audio_url: Grabación de audio del encuentro
* closed_at: La fecha en la que se cerró el encuentro
* registration_terms: Los términos y condiciones de registro al encuentro que se aceptaron antes de participar
* available_slots: El número de plazas disponibles para el encuentro
* registrations_enabled: Si se habilitó la inscripción al encuentro
* customize_registration_email: Posibilidad de introducir un correo electrónico personalizado al registrarse en el encuentro
* type_of_meeting: El tipo de reunión
* iframe_access_level: El nivel de acceso de la sala de videoconferencias del encuentro
* iframe_embed_type: El tipo de visualización de la sala de videoconferencias del encuentro
* reserved_slots: El número de plazas reservadas que tenía el encuentro
* registration_type: El tipo de inscripción al encuentro



